/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.systems.LanguageSystem;

public class Damage {
    public final double amount;
    public final BoundingBox box;
    public final AEntityB_Existing damgeSource;
    public final IWrapperEntity entityResponsible;
    public final LanguageSystem.LanguageEntry language;
    public boolean isHand;
    public boolean isFire;
    public boolean isWater;
    public boolean isExplosion;
    public boolean ignoreArmor;
    public boolean ignoreCooldown;
    public Point3D knockback;
    public List<JSONPotionEffect> effects;

    public Damage(double amount, BoundingBox box, AEntityB_Existing damgeSource, IWrapperEntity entityResponsible, LanguageSystem.LanguageEntry language) {
        this.amount = amount;
        this.box = box;
        this.damgeSource = damgeSource;
        this.entityResponsible = entityResponsible;
        this.language = language;
    }

    public Damage(Damage otherDamage, double factor, BoundingBox box) {
        this.amount = otherDamage.amount * factor;
        this.box = box;
        this.damgeSource = otherDamage.damgeSource;
        this.entityResponsible = otherDamage.entityResponsible;
        this.language = otherDamage.language;
        this.isHand = otherDamage.isHand;
        this.isFire = otherDamage.isFire;
        this.isWater = otherDamage.isWater;
        this.isExplosion = otherDamage.isExplosion;
        this.effects = otherDamage.effects;
        this.ignoreArmor = otherDamage.ignoreArmor;
        this.ignoreCooldown = otherDamage.ignoreCooldown;
    }

    public Damage(PartGun gun, BoundingBox box, double amount) {
        this.amount = amount;
        this.box = box;
        this.damgeSource = gun;
        this.entityResponsible = gun.lastController;
        this.language = this.entityResponsible != null ? LanguageSystem.DEATH_BULLET_PLAYER : LanguageSystem.DEATH_BULLET_NULL;
        this.ignoreCooldown = true;
        if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.WATER)) {
            this.isWater = true;
        }
        if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY)) {
            this.isFire = true;
        }
        if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.ARMOR_PIERCING)) {
            this.ignoreArmor = true;
        }
        if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.knockback != 0.0f) {
            this.knockback = box.globalCenter.copy().subtract(gun.position).normalize().scale(((JSONBullet)gun.lastLoadedBullet.definition).bullet.knockback);
        }
        this.effects = ((JSONBullet)gun.lastLoadedBullet.definition).bullet.effects;
    }

    public Damage setHand() {
        this.isHand = true;
        return this;
    }

    public Damage setFire() {
        this.isFire = true;
        return this;
    }

    public Damage setWater() {
        this.isWater = true;
        return this;
    }

    public Damage setExplosive() {
        this.isExplosion = true;
        return this;
    }

    public Damage setEffects(List<JSONPotionEffect> effects) {
        this.effects = effects;
        return this;
    }

    public Damage ignoreArmor() {
        this.ignoreArmor = true;
        return this;
    }

    public Damage ignoreCooldown() {
        this.ignoreCooldown = true;
        return this;
    }
}

